/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.util;

import bluej.Boot;
import bluej.Config;
import bluej.utility.Debug;
import bluej.utility.Utility;
import greenfoot.GreenfootImage;
import greenfoot.UserInfo;
import greenfoot.core.ImageCache;
import greenfoot.platforms.GreenfootUtilDelegate;
import greenfoot.util.GraphicsUtilities;
import greenfoot.util.ShadowRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ImageObserver;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GreenfootUtil {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    private static GreenfootUtilDelegate delegate;
    private static ImageCache imageCache;
    private static final Color urlColor;
    private static boolean haveCheckedForMp3;
    private static boolean mp3available;
    private static Set<Long> allowedForeground;

    public static void initialise(GreenfootUtilDelegate newDelegate) {
        delegate = newDelegate;
        imageCache = ImageCache.getInstance();
    }

    public static String extractClassName(String qualifiedName) {
        int index = qualifiedName.lastIndexOf(46);
        String name = qualifiedName;
        if (index >= 0) {
            name = qualifiedName.substring(index + 1);
        }
        return name;
    }

    public static String extractPackageName(String qualifiedName) {
        int index = qualifiedName.lastIndexOf(46);
        String name = "";
        if (index >= 0) {
            name = qualifiedName.substring(0, index);
        }
        return name;
    }

    public static JComponent createSpacer(int axis, int width) {
        JPanel spacer = new JPanel();
        spacer.setMinimumSize(new Dimension(0, 0));
        Dimension size = new Dimension();
        size.width = 0;
        size.height = 0;
        if (axis == 0) {
            size.width = width;
        } else {
            size.height = width;
        }
        spacer.setPreferredSize(size);
        spacer.setMaximumSize(size);
        spacer.setBorder(null);
        return spacer;
    }

    public static JLabel createHelpLabel() {
        JLabel helpLabel = new JLabel();
        Font smallFont = helpLabel.getFont().deriveFont(2, 11.0f);
        helpLabel.setFont(smallFont);
        return helpLabel;
    }

    public static boolean isImage(File file) {
        try {
            BufferedImage img = ImageIO.read(file);
            return img != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static Image getScaledImage(Image inputImage, int w, int h) {
        ImageWaiter waiter = new ImageWaiter(inputImage);
        waiter.waitDimensions();
        int inputw = waiter.width;
        int inputh = waiter.height;
        if (w == inputw && h == inputh) {
            return inputImage;
        }
        BufferedImage rImage = GraphicsUtilities.createCompatibleTranslucentImage(w, h);
        Graphics2D graphics = rImage.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        if (inputw <= w && inputh <= h) {
            int xoffs = (w - inputw) / 2;
            int yoffs = (h - inputh) / 2;
            waiter.drawWait(graphics, xoffs, yoffs);
        } else {
            float xscale = (float)w / (float)inputw;
            float yscale = (float)h / (float)inputh;
            float scale = xscale < yscale ? xscale : yscale;
            int neww = (int)((float)inputw * scale);
            int newh = (int)((float)inputh * scale);
            if (neww > inputw) {
                neww = inputw;
            }
            if (newh > inputh) {
                newh = inputh;
            }
            if (neww < 1) {
                neww = 1;
            }
            if (newh < 1) {
                newh = 1;
            }
            if (neww < w && newh < h) {
                ++neww;
                ++newh;
            }
            int xoffs = (w - neww) / 2;
            int yoffs = (h - newh) / 2;
            try {
                waiter.drawWait(graphics, xoffs, yoffs, neww, newh);
            }
            catch (OutOfMemoryError oome) {
                graphics.setColor(Color.white);
                graphics.fillRect(1, 1, w - 2, h - 2);
                graphics.setColor(Color.red);
                graphics.drawRect(0, 0, w - 1, h - 1);
                graphics.drawLine(0, 0, w, h);
                graphics.drawLine(0, h, w, 0);
            }
        }
        graphics.dispose();
        return rImage;
    }

    public static void copyDir(File src, File dst) {
        if (!src.isDirectory()) {
            return;
        }
        if (!dst.exists()) {
            dst.mkdirs();
        }
        File[] files = src.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            File newDst = new File(dst, file.getName());
            if (file.isDirectory()) {
                GreenfootUtil.copyDir(file, newDst);
                continue;
            }
            GreenfootUtil.copyFile(file, newDst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dst) {
        if (!src.isFile() || dst.isDirectory()) {
            return;
        }
        dst.getParentFile().mkdirs();
        if (dst.exists()) {
            dst.delete();
        }
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(src));
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(dst));
            byte[] buffer = new byte[8192];
            int read = 0;
            while (read != -1) {
                os.write(buffer, 0, read);
                read = is.read(buffer);
            }
            os.flush();
            is.close();
            os.close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Iterable<String> getSoundFiles() {
        return delegate.getSoundFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL getURL(String filename, String dir) throws FileNotFoundException {
        if (filename == null) {
            throw new NullPointerException("Filename must not be null.");
        }
        URL url = delegate.getResource(dir + "/" + filename);
        if (url == null) {
            url = delegate.getResource(filename);
        }
        if (url == null) {
            File f = new File(filename);
            try {
                if (f.canRead()) {
                    url = f.toURI().toURL();
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (url == null) {
            InputStream s = null;
            try {
                url = new URL(filename);
                s = url.openStream();
                s.close();
            }
            catch (MalformedURLException e) {
                url = null;
            }
            catch (IOException e) {
                url = null;
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        GreenfootUtil.checkCase(url);
        if (url == null) {
            throw new FileNotFoundException("Could not find file: " + filename);
        }
        return url;
    }

    private static void checkCase(URL url) {
        if (url != null) {
            String errMsg = null;
            try {
                File f = new File(url.toURI());
                String givenName = f.getName();
                String realName = f.getCanonicalFile().getName();
                if (!realName.equals(givenName) && realName.equalsIgnoreCase(givenName)) {
                    errMsg = "Filename '" + givenName + "' has the wrong case. It should be: '" + realName + "'";
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (errMsg != null) {
                throw new IllegalArgumentException(errMsg);
            }
        }
    }

    public static String getGreenfootLogoPath() {
        return delegate.getGreenfootLogoPath();
    }

    public static boolean canBeInstantiated(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        if (cls.isEnum() || cls.isInterface()) {
            return false;
        }
        return !Modifier.isAbstract(cls.getModifiers());
    }

    public static BufferedImage createDragShadow(BufferedImage image) {
        BufferedImage dragImage = ShadowRenderer.createDropShadow(image, 3, 0.3f, Color.BLACK);
        Graphics2D g2 = dragImage.createGraphics();
        g2.drawImage((Image)image, 0, 0, null);
        g2.dispose();
        return dragImage;
    }

    public static JButton createButton(Action action) {
        JButton button = new JButton(action);
        button.setFocusable(false);
        return button;
    }

    private static Font deriveUnderlinedFont(Font f) {
        HashMap<TextAttribute, Integer> attr = new HashMap<TextAttribute, Integer>();
        attr.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        Font underLineFont = f.deriveFont(attr);
        return underLineFont;
    }

    public static void makeLink(JLabel label, final String url) {
        label.setCursor(new Cursor(12));
        label.setForeground(urlColor);
        Font f = label.getFont();
        Font underLineFont = GreenfootUtil.deriveUnderlinedFont(f);
        label.setFont(underLineFont);
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Utility.openWebBrowser((String)url);
            }
        });
    }

    public static void makeGreenfootTitle(Frame frame) {
        String title = frame.getTitle();
        String newTitle = title.replaceAll("BlueJ", "Greenfoot");
        frame.setTitle(newTitle);
    }

    public static Set<File> get3rdPartyLibs() {
        File bluejLibDir = Config.getBlueJLibDir();
        String[] thirdPartyLibs = Boot.GREENFOOT_EXPORT_JARS;
        TreeSet<File> jars = new TreeSet<File>();
        for (String lib : thirdPartyLibs) {
            jars.add(new File(bluejLibDir, lib));
        }
        return jars;
    }

    public static boolean isMp3LibAvailable() {
        if (!haveCheckedForMp3) {
            URL url = delegate.getResource("javazoom/jl/decoder/BitstreamException.class");
            mp3available = url != null;
            haveCheckedForMp3 = true;
        }
        return mp3available;
    }

    public static File createNumberedFile(File dir, String name, String type) throws IOException {
        File f = new File(dir, name + "." + type);
        int number = 1;
        while (!f.createNewFile()) {
            String numberString = null;
            numberString = number < 10 ? "0" + number : "" + number;
            f = new File(dir, name + numberString + "." + type);
            ++number;
        }
        return f;
    }

    public static GreenfootImage getGreenfootImage(String className, String imageName) {
        GreenfootImage image = null;
        if (imageName == null) {
            return image;
        }
        if (GreenfootUtil.isInvalidImageFilename(imageName)) {
            return image;
        }
        if (className.equals("Actor")) {
            return new GreenfootImage(GreenfootUtil.getGreenfootLogoPath());
        }
        try {
            image = new GreenfootImage(imageName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return image;
    }

    public static void removeCachedImage(String className) {
        imageCache.removeCachedImage(className);
    }

    public static boolean addCachedImage(String name, GreenfootImage image) {
        return imageCache.addCachedImage(name, image);
    }

    public static GreenfootImage getCachedImage(String name) {
        return imageCache.getCachedImage(name);
    }

    public static boolean isInvalidImageFilename(String fileName) {
        return imageCache.isNullCachedImage(fileName);
    }

    public static void displayMessage(Component parent, String messageText) {
        delegate.displayMessage(parent, messageText);
    }

    public static String removeExtension(String full) {
        int n = full.lastIndexOf(46);
        if (n == -1) {
            return full;
        }
        return full.substring(0, n);
    }

    public static boolean isStorageSupported() {
        return delegate.isStorageSupported();
    }

    public static UserInfo getCurrentUserInfo() {
        return delegate.getCurrentUserInfo();
    }

    public static boolean storeCurrentUserInfo(UserInfo data) {
        if (data.getUserName().equals(GreenfootUtil.getUserName())) {
            return delegate.storeCurrentUserInfo(data);
        }
        System.err.println("Attempted to store the data for another user, \"" + data.getUserName() + "\" (i.e. a user other than the current user, \"" + GreenfootUtil.getUserName() + "\")");
        return false;
    }

    public static List<UserInfo> getTopUserInfo(int limit) {
        return delegate.getTopUserInfo(limit);
    }

    public static GreenfootImage getUserImage(String userName) {
        if (userName == null || userName.equals("")) {
            userName = GreenfootUtil.getUserName();
        }
        GreenfootImage r = null;
        if (userName != null) {
            r = delegate.getUserImage(userName);
        }
        if (r == null) {
            r = new GreenfootImage(50, 50);
            r.setColor(Color.DARK_GRAY);
            r.fill();
            int CHARS_PER_LINE = 6;
            StringBuilder wrappedName = new StringBuilder();
            if (userName == null) {
                userName = "";
            }
            for (int i = 0; i < userName.length(); i += 6) {
                wrappedName.append(userName.substring(i, Math.min(userName.length(), i + 6))).append("\n");
            }
            GreenfootImage textImage = new GreenfootImage(wrappedName.toString(), 15, Color.WHITE, Color.DARK_GRAY);
            r.drawImage(textImage, Math.max(0, (50 - textImage.getWidth()) / 2), Math.max(0, (50 - textImage.getHeight()) / 2));
        }
        return r;
    }

    public static String getUserName() {
        return delegate.getUserName();
    }

    public static List<UserInfo> getNearbyUserData(int maxAmount) {
        return delegate.getNearbyUserInfo(maxAmount);
    }

    public static void convertToGreyImage(BufferedImage image) {
        new ColorConvertOp(ColorSpace.getInstance(1003), null).filter(image, image);
    }

    public static void allowForeground(long processId) {
        if (Config.isWinOS() && !allowedForeground.contains(processId)) {
            try {
                File nativeJAR = new File(Config.getBlueJLibDir(), "greenfoot-native.jar");
                File jnaJAR = new File(Config.getBlueJLibDir(), "jna-4.2.0.jar");
                File jnaPlatformJAR = new File(Config.getBlueJLibDir(), "jna-platform-4.2.0.jar");
                List<URL> urls = Stream.of(nativeJAR, jnaJAR, jnaPlatformJAR).flatMap(f -> {
                    try {
                        return Stream.of(f.toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        Debug.reportError((Throwable)e);
                        return Stream.empty();
                    }
                }).collect(Collectors.toList());
                URLClassLoader cl = new URLClassLoader(urls.toArray(new URL[0]), null);
                Class<?> clz = cl.loadClass("greenfoot.util.NativeUtil");
                Method m = clz.getDeclaredMethod("allowForegroundWindowsOS", Long.TYPE);
                m.invoke(null, processId);
                allowedForeground.add(processId);
                Debug.message((String)"Successfully allowed BlueJ/Greenfoot foreground");
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                Debug.reportError((Throwable)e);
            }
        }
    }

    static {
        urlColor = new Color(0, 90, 200);
        haveCheckedForMp3 = false;
        mp3available = false;
        allowedForeground = new HashSet<Long>();
    }

    public static class ImageWaiter
    implements ImageObserver {
        public int width;
        public int height;
        public boolean done;
        public boolean gotDimensions;
        public Image src;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ImageWaiter(Image src) {
            this.src = src;
            this.done = false;
            this.gotDimensions = false;
            ImageWaiter imageWaiter = this;
            synchronized (imageWaiter) {
                this.width = src.getWidth(this);
                this.height = src.getHeight(this);
                if (this.width != -1 && this.height != -1) {
                    this.gotDimensions = true;
                }
            }
        }

        public synchronized void waitDimensions() {
            try {
                while (!this.gotDimensions) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public synchronized void drawWait(Graphics canvas, int x, int y) {
            this.done = canvas.drawImage(this.src, x, y, this);
            try {
                while (!this.done) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public synchronized void drawWait(Graphics canvas, int x, int y, int w, int h) {
            this.done = canvas.drawImage(this.src, x, y, w, h, this);
            try {
                while (!this.done) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public synchronized boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            if (!this.gotDimensions) {
                if ((infoflags & 1) != 0) {
                    this.width = width;
                }
                if ((infoflags & 2) != 0) {
                    this.height = height;
                }
                if (this.width != -1 && this.height != -1) {
                    this.gotDimensions = true;
                    this.notify();
                    return false;
                }
                return true;
            }
            if ((infoflags & 0xF0) != 0) {
                this.done = true;
                this.notify();
                return false;
            }
            return true;
        }
    }
}

