/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.sound;

import greenfoot.sound.GreenfootAudioInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;

public class MemoryAudioInputStream
implements GreenfootAudioInputStream {
    private byte[] sound;
    private int startOffset;
    private int endOffset;
    private AudioFormat format;
    private int markIndex;
    private int curIndex;

    public MemoryAudioInputStream(byte[] sound, AudioFormat format) {
        this.curIndex = 0;
        this.markIndex = 0;
        this.startOffset = 0;
        this.endOffset = sound.length;
        this.sound = sound;
        this.format = format;
    }

    public MemoryAudioInputStream(byte[] sound, int offset, int length, AudioFormat format) {
        this.markIndex = this.curIndex = offset;
        this.startOffset = offset;
        this.endOffset = offset + length;
        this.sound = sound;
        this.format = format;
    }

    private int getFrameSize() {
        return this.format.getFrameSize();
    }

    @Override
    public int available() throws IOException {
        return this.endOffset - this.curIndex;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public AudioFormat getFormat() {
        return this.format;
    }

    @Override
    public String getSource() {
        return "Internal buffer";
    }

    @Override
    public void mark(int readlimit) {
        this.markIndex = this.curIndex;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void open() throws IOException, UnsupportedAudioFileException {
        this.curIndex = this.startOffset;
    }

    @Override
    public int read() throws IOException {
        if (this.getFrameSize() != 1) {
            throw new IOException("Attempted to read single byte but frame size is not 1");
        }
        if (this.curIndex < this.endOffset) {
            return this.sound[this.curIndex++];
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.curIndex >= this.endOffset) {
            return -1;
        }
        int maxRead = len - len % this.getFrameSize();
        if (this.curIndex + maxRead > this.endOffset) {
            int left = this.endOffset - this.curIndex;
            maxRead = left - left % this.getFrameSize();
        }
        System.arraycopy(this.sound, this.curIndex, b, off, maxRead);
        this.curIndex += maxRead;
        return maxRead;
    }

    @Override
    public void reset() throws IOException {
        this.curIndex = this.markIndex;
    }

    @Override
    public void restart() throws IOException, UnsupportedAudioFileException {
        this.curIndex = this.startOffset;
    }

    @Override
    public long skip(long n) throws IOException {
        if ((long)this.curIndex + n <= (long)this.endOffset) {
            this.curIndex = (int)((long)this.curIndex + n);
            return n;
        }
        int diff = this.endOffset - this.curIndex;
        this.curIndex = this.endOffset;
        return diff;
    }
}

