/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.input;

import greenfoot.event.TriggeredKeyListener;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;

public class KeyboardManager
implements TriggeredKeyListener,
FocusListener {
    private String lastKeyTyped;
    private int numKeys = 100;
    private boolean[] keyLatched = new boolean[this.numKeys];
    private boolean[] keyDown = new boolean[this.numKeys];
    private int maxNamedKey = 0;
    private String[] keyNames;
    private Map<String, Integer> keyCodeMap = new HashMap<String, Integer>();
    private boolean hasNumLock = true;

    public KeyboardManager() {
        this.addAllKeys();
        this.buildKeyNameArray();
    }

    public synchronized void clearLatchedKeys() {
        for (int i = 0; i < this.numKeys; ++i) {
            int n = i;
            this.keyLatched[n] = this.keyLatched[n] & this.keyDown[i];
        }
    }

    private void addAllKeys() {
        this.addKey("up", 38);
        this.addKey("down", 40);
        this.addKey("left", 37);
        this.addKey("right", 39);
        this.addKey("space", 32);
        this.addKey("enter", 10);
        this.addKey("escape", 27);
        this.addKey("f1", 112);
        this.addKey("f2", 113);
        this.addKey("f3", 114);
        this.addKey("f4", 115);
        this.addKey("f5", 116);
        this.addKey("f6", 117);
        this.addKey("f7", 118);
        this.addKey("f8", 119);
        this.addKey("f9", 120);
        this.addKey("f10", 121);
        this.addKey("f11", 122);
        this.addKey("f12", 123);
        this.addKey("backspace", 8);
        this.addKey("'", 222);
        this.addKey("shift", 16);
        this.addKey("control", 17);
    }

    private void addKey(String keyName, int keyCode) {
        this.keyCodeMap.put(keyName, keyCode);
        if (keyCode + 1 > this.maxNamedKey) {
            this.maxNamedKey = keyCode + 1;
        }
    }

    private void buildKeyNameArray() {
        this.keyNames = new String[this.maxNamedKey];
        for (String keyName : this.keyCodeMap.keySet()) {
            int keyCode = this.keyCodeMap.get(keyName);
            this.keyNames[keyCode] = keyName;
        }
        this.keyNames[32] = null;
        this.keyNames[10] = null;
        this.keyNames[27] = null;
        this.keyNames[9] = null;
        this.keyNames[8] = null;
        this.keyNames[222] = null;
    }

    private void checkKeyArrays(int keycode) {
        int nsize = keycode + 1;
        if (nsize > this.numKeys) {
            boolean[] newKeyLatched = new boolean[nsize];
            boolean[] newKeyDown = new boolean[nsize];
            for (int i = 0; i < this.numKeys; ++i) {
                newKeyLatched[i] = this.keyLatched[i];
                newKeyDown[i] = this.keyDown[i];
            }
            this.keyLatched = newKeyLatched;
            this.keyDown = newKeyDown;
            this.numKeys = nsize;
        }
    }

    public synchronized String getKey() {
        String r = this.lastKeyTyped;
        this.lastKeyTyped = null;
        return r;
    }

    public synchronized boolean isKeyDown(int keycode) {
        if (keycode < this.numKeys) {
            boolean pressed = this.keyDown[keycode] || this.keyLatched[keycode];
            this.keyLatched[keycode] = false;
            return pressed;
        }
        return false;
    }

    public boolean isKeyDown(String keyId) {
        Integer code = this.keyCodeMap.get(keyId.toLowerCase());
        if (code != null) {
            return this.isKeyDown(code);
        }
        if (keyId.codePointCount(0, keyId.length()) == 1) {
            int keyChar = keyId.codePointAt(0);
            keyChar = Character.toUpperCase(keyChar);
            int keyCode = KeyEvent.getExtendedKeyCodeForChar(keyChar);
            return this.isKeyDown(keyCode);
        }
        throw new IllegalArgumentException("\"" + keyId + "\" key doesn't exist. Please change the key name while invoking Greenfoot.isKeyDown() method");
    }

    @Override
    public synchronized void keyPressed(KeyEvent event) {
        int keyCode = event.getExtendedKeyCode();
        this.pressKey(keyCode);
    }

    private void pressKey(int keyCode) {
        keyCode = this.numLockTranslate(keyCode);
        this.checkKeyArrays(keyCode);
        this.keyLatched[keyCode] = true;
        this.keyDown[keyCode] = true;
    }

    @Override
    public synchronized void keyReleased(KeyEvent event) {
        int keyCode = event.getExtendedKeyCode();
        this.releaseKey(keyCode);
    }

    private void releaseKey(int keyCode) {
        String keyName;
        keyCode = this.numLockTranslate(keyCode);
        this.checkKeyArrays(keyCode);
        this.keyDown[keyCode] = false;
        if (keyCode < this.maxNamedKey && (keyName = this.keyNames[keyCode]) != null) {
            this.lastKeyTyped = keyName;
        }
    }

    @Override
    public void listeningStarted(Object obj) {
    }

    @Override
    public void listeningEnded() {
        this.releaseAllKeys();
    }

    private int numLockTranslate(int keycode) {
        if (keycode >= 96 && keycode <= 105) {
            return keycode - 96 + 48;
        }
        boolean numlock = true;
        if (this.hasNumLock) {
            try {
                numlock = Toolkit.getDefaultToolkit().getLockingKeyState(144);
            }
            catch (UnsupportedOperationException usoe) {
                this.hasNumLock = false;
            }
        }
        if (numlock) {
            if (keycode == 224) {
                keycode = 56;
            } else if (keycode == 225) {
                keycode = 50;
            } else if (keycode == 226) {
                keycode = 52;
            } else if (keycode == 227) {
                keycode = 54;
            }
        } else if (keycode == 224) {
            keycode = 38;
        } else if (keycode == 225) {
            keycode = 40;
        } else if (keycode == 226) {
            System.out.println("VK_KP_LEFT!");
            keycode = 37;
        } else if (keycode == 227) {
            keycode = 39;
        }
        return keycode;
    }

    @Override
    public synchronized void keyTyped(KeyEvent key) {
        char c = key.getKeyChar();
        this.lastKeyTyped = c == '\n' || c == '\r' ? "enter" : (c == '\t' ? "tab" : (c == '\b' ? "backspace" : (c == ' ' ? "space" : (c == '\u001b' ? "escape" : "" + c))));
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.releaseAllKeys();
    }

    private synchronized void releaseAllKeys() {
        for (int keyCode = 0; keyCode < this.keyDown.length; ++keyCode) {
            this.keyDown[keyCode] = false;
            this.keyLatched[keyCode] = false;
        }
    }
}

