/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.input;

import greenfoot.Actor;
import greenfoot.event.SimulationEvent;
import greenfoot.event.SimulationListener;
import greenfoot.event.TriggeredKeyAdapter;
import greenfoot.event.TriggeredKeyListener;
import greenfoot.event.TriggeredMouseAdapter;
import greenfoot.event.TriggeredMouseListener;
import greenfoot.event.TriggeredMouseMotionAdapter;
import greenfoot.event.TriggeredMouseMotionListener;
import greenfoot.event.WorldEvent;
import greenfoot.event.WorldListener;
import greenfoot.gui.input.states.ConstructorDragState;
import greenfoot.gui.input.states.ConstructorDragWhileRunningState;
import greenfoot.gui.input.states.DisabledState;
import greenfoot.gui.input.states.IdleState;
import greenfoot.gui.input.states.MoveState;
import greenfoot.gui.input.states.QuickAddDragState;
import greenfoot.gui.input.states.RunningState;
import greenfoot.gui.input.states.State;
import java.awt.EventQueue;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;

public class InputManager
implements SimulationListener,
KeyListener,
MouseListener,
MouseMotionListener,
WorldListener {
    private State state = null;
    private TriggeredKeyListener activeKeyListener;
    private TriggeredMouseListener activeMouseListener;
    private TriggeredMouseMotionListener activeMouseMotionListener;

    public InputManager() {
        DisabledState disabledState = DisabledState.initialize(this, new TriggeredKeyAdapter(), new TriggeredMouseAdapter(), new TriggeredMouseMotionAdapter());
        this.switchAndActivateState(disabledState, null);
    }

    public void setRunningListeners(TriggeredKeyListener runningKeyListener, TriggeredMouseListener runningMouseListener, TriggeredMouseMotionListener runningMouseMotionListener) {
        RunningState.initialize(this, runningKeyListener, runningMouseListener, runningMouseMotionListener);
    }

    public void setIdleListeners(TriggeredKeyListener idleKeyListener, TriggeredMouseListener idleMouseListener, TriggeredMouseMotionListener idleMouseMotionListener) {
        IdleState.initialize(this, idleKeyListener, idleMouseListener, idleMouseMotionListener);
    }

    public void setDragListeners(TriggeredKeyListener dragKeyListener, TriggeredMouseListener dragMouseListener, TriggeredMouseMotionListener dragMouseMotionListener) {
        QuickAddDragState.initialize(this, dragKeyListener, dragMouseListener, dragMouseMotionListener);
        ConstructorDragState.initialize(this, dragKeyListener, dragMouseListener, dragMouseMotionListener);
        ConstructorDragWhileRunningState.initialize(this, dragKeyListener, dragMouseListener, dragMouseMotionListener);
    }

    public void setMoveListeners(TriggeredKeyListener moveKeyListener, TriggeredMouseListener moveMouseListener, TriggeredMouseMotionListener moveMouseMotionListener) {
        MoveState.initialize(this, moveKeyListener, moveMouseListener, moveMouseMotionListener);
    }

    public void init() throws IllegalStateException {
        DisabledState.getInstance();
        RunningState.getInstance();
        MoveState.getInstance();
        QuickAddDragState.getInstance();
        ConstructorDragState.getInstance();
        ConstructorDragWhileRunningState.getInstance();
        this.switchAndActivateState(IdleState.getInstance(), null);
    }

    public void activateListeners(TriggeredKeyListener keyL, TriggeredMouseListener mouseL, TriggeredMouseMotionListener mouseMotionL, Object obj) {
        if (this.activeKeyListener != null) {
            this.activeKeyListener.listeningEnded();
        }
        if (this.activeMouseListener != null) {
            this.activeMouseListener.listeningEnded();
        }
        if (this.activeMouseMotionListener != null) {
            this.activeMouseMotionListener.listeningEnded();
        }
        this.activeKeyListener = keyL;
        this.activeMouseListener = mouseL;
        this.activeMouseMotionListener = mouseMotionL;
        this.activeKeyListener.listeningStarted(obj);
        this.activeMouseListener.listeningStarted(obj);
        this.activeMouseMotionListener.listeningStarted(obj);
    }

    public void switchAndActivateState(State newState, Object obj) {
        this.state = newState;
        this.state.activate(obj);
    }

    @Override
    public void simulationChanged(SimulationEvent e) {
        if (e.getType() == 0) {
            EventQueue.invokeLater(() -> this.state.switchToNextState(State.Event.SIMULATION_STARTED, null));
        } else if (e.getType() == 1) {
            EventQueue.invokeLater(() -> this.state.switchToNextState(State.Event.SIMULATION_STOPPED, null));
        }
    }

    public void objectCreated(Actor object) {
        this.state.switchToNextState(State.Event.CONSTRUCTOR_INVOKED, object);
    }

    public void objectMoved(Actor object) {
        this.state.switchToNextState(State.Event.OBJECT_MOVED, object);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 16) {
            this.state.switchToNextState(State.Event.SHIFT_PRESSED, null);
        }
        if (e.getKeyCode() == 27) {
            this.state.switchToNextState(State.Event.ESC_PRESSED, null);
        }
        this.activeKeyListener.keyPressed(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.activeKeyListener.keyReleased(e);
        if (e.getKeyCode() == 16) {
            this.state.switchToNextState(State.Event.SHIFT_RELEASED, null);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.activeKeyListener.keyTyped(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.checkShift(e);
        this.activeMouseListener.mouseClicked(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.checkShift(e);
        this.activeMouseListener.mousePressed(e);
        if (SwingUtilities.isLeftMouseButton(e) && !e.isShiftDown()) {
            this.state.switchToNextState(State.Event.MOUSE_PRESSED, null);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.checkShift(e);
        this.activeMouseListener.mouseReleased(e);
        this.state.switchToNextState(State.Event.MOUSE_RELEASED, null);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.checkShift(e);
        this.activeMouseListener.mouseEntered(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.checkShift(e);
        this.activeMouseListener.mouseExited(e);
    }

    private void checkShift(MouseEvent e) {
        if (this.state == QuickAddDragState.getInstance() && !e.isShiftDown()) {
            this.state.switchToNextState(State.Event.SHIFT_RELEASED, null);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.checkShift(e);
        this.activeMouseMotionListener.mouseDragged(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.checkShift(e);
        this.activeMouseMotionListener.mouseMoved(e);
    }

    @Override
    public void worldCreated(WorldEvent e) {
        this.state.switchToNextState(State.Event.WORLD_CREATED, null);
    }

    @Override
    public void worldRemoved(WorldEvent e) {
        this.state.switchToNextState(State.Event.WORLD_REMOVED, null);
    }
}

