/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import bluej.debugmgr.objectbench.ObjectBenchInterface;
import greenfoot.Actor;
import greenfoot.ActorVisitor;
import greenfoot.World;
import greenfoot.WorldVisitor;
import greenfoot.core.ActInterruptedException;
import greenfoot.core.ObjectDragProxy;
import greenfoot.core.Simulation;
import greenfoot.event.SimulationEvent;
import greenfoot.event.SimulationListener;
import greenfoot.event.TriggeredKeyListener;
import greenfoot.event.TriggeredMouseListener;
import greenfoot.event.TriggeredMouseMotionListener;
import greenfoot.event.WorldEvent;
import greenfoot.event.WorldListener;
import greenfoot.gui.DragListener;
import greenfoot.gui.DropTarget;
import greenfoot.gui.WorldCanvas;
import greenfoot.gui.input.InputManager;
import greenfoot.gui.input.KeyboardManager;
import greenfoot.gui.input.mouse.LocationTracker;
import greenfoot.gui.input.mouse.MousePollingManager;
import greenfoot.gui.input.mouse.WorldLocator;
import greenfoot.platforms.WorldHandlerDelegate;
import greenfoot.util.GraphicsUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class WorldHandler
implements TriggeredMouseListener,
TriggeredMouseMotionListener,
TriggeredKeyListener,
DropTarget,
DragListener,
SimulationListener {
    private boolean worldIsSet;
    private World initialisingWorld;
    private volatile World world;
    private WorldCanvas worldCanvas;
    private int dragBeginX;
    private int dragBeginY;
    private boolean objectDropped = true;
    private KeyboardManager keyboardManager;
    private static WorldHandler instance;
    private EventListenerList listenerList = new EventListenerList();
    private WorldHandlerDelegate handlerDelegate;
    private MousePollingManager mousePollingManager;
    private InputManager inputManager;
    private int dragOffsetX;
    private int dragOffsetY;
    private Actor dragActor;
    private boolean dragActorMoved;
    private Cursor defaultCursor;
    private static ReentrantReadWriteLock lock;
    public static final int READ_LOCK_TIMEOUT = 500;
    private Object repaintLock = new Object();
    private boolean isRepaintPending = false;

    public static synchronized void initialise(WorldCanvas worldCanvas, WorldHandlerDelegate helper) {
        instance = new WorldHandler(worldCanvas, helper);
    }

    public static synchronized void initialise() {
        instance = new WorldHandler();
    }

    public static synchronized WorldHandler getInstance() {
        return instance;
    }

    private WorldHandler() {
        instance = this;
        this.mousePollingManager = new MousePollingManager(null);
        this.handlerDelegate = new WorldHandlerDelegate(){

            @Override
            public void discardWorld(World world) {
            }

            @Override
            public InputManager getInputManager() {
                return null;
            }

            @Override
            public void instantiateNewWorld() {
            }

            @Override
            public boolean maybeShowPopup(MouseEvent e) {
                return false;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            @Override
            public void setWorld(World oldWorld, World newWorld) {
            }

            @Override
            public void setWorldHandler(WorldHandler handler) {
            }

            @Override
            public void addActor(Actor actor, int x, int y) {
            }

            @Override
            public void actorDragged(Actor actor, int xCell, int yCell) {
            }

            @Override
            public void objectAddedToWorld(Actor actor) {
            }

            @Override
            public String ask(String prompt) {
                return "";
            }
        };
    }

    private WorldHandler(WorldCanvas worldCanvas, WorldHandlerDelegate handlerDelegate) {
        instance = this;
        this.handlerDelegate = handlerDelegate;
        this.handlerDelegate.setWorldHandler(this);
        this.worldCanvas = worldCanvas;
        this.mousePollingManager = new MousePollingManager(null);
        worldCanvas.setDropTargetListener(this);
        LocationTracker.instance().setSourceComponent(worldCanvas);
        this.keyboardManager = new KeyboardManager();
        worldCanvas.addFocusListener(this.keyboardManager);
        this.inputManager = handlerDelegate.getInputManager();
        this.addWorldListener(this.inputManager);
        this.inputManager.setRunningListeners(this.getKeyboardManager(), this.mousePollingManager, this.mousePollingManager);
        worldCanvas.addMouseListener(this.inputManager);
        worldCanvas.addMouseMotionListener(this.inputManager);
        worldCanvas.addKeyListener(this.inputManager);
        this.inputManager.init();
        this.defaultCursor = worldCanvas.getCursor();
    }

    public KeyboardManager getKeyboardManager() {
        return this.keyboardManager;
    }

    public MousePollingManager getMouseManager() {
        return this.mousePollingManager;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.handlerDelegate.mouseClicked(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Actor actor;
        World world = this.world;
        boolean isPopUp = this.handlerDelegate.maybeShowPopup(e);
        if (world != null && SwingUtilities.isLeftMouseButton(e) && !isPopUp && (actor = this.getObject(e.getX(), e.getY())) != null) {
            Point p = e.getPoint();
            this.startDrag(actor, p, world);
        }
    }

    private void startDrag(Actor actor, Point p, World world) {
        this.dragActor = actor;
        this.dragActorMoved = false;
        this.dragBeginX = ActorVisitor.getX(actor) * world.getCellSize() + world.getCellSize() / 2;
        this.dragBeginY = ActorVisitor.getY(actor) * world.getCellSize() + world.getCellSize() / 2;
        this.dragOffsetX = this.dragBeginX - p.x;
        this.dragOffsetY = this.dragBeginY - p.y;
        this.objectDropped = false;
        SwingUtilities.getWindowAncestor(this.worldCanvas).toFront();
        this.worldCanvas.setCursor(Cursor.getPredefinedCursor(12));
        this.drag(actor, p);
    }

    public boolean isDragging() {
        return this.dragActor != null;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.handlerDelegate.maybeShowPopup(e);
        if (SwingUtilities.isLeftMouseButton(e)) {
            if (this.dragActor != null && this.dragActorMoved) {
                Simulation.getInstance().runLater(new Runnable(){
                    private Actor dragActor;
                    {
                        this.dragActor = WorldHandler.this.dragActor;
                    }

                    @Override
                    public void run() {
                        int ax = ActorVisitor.getX(this.dragActor);
                        int ay = ActorVisitor.getY(this.dragActor);
                        ActorVisitor.setLocationInPixels(this.dragActor, WorldHandler.this.dragBeginX, WorldHandler.this.dragBeginY);
                        this.dragActor.setLocation(ax, ay);
                        WorldHandler.this.handlerDelegate.actorDragged(this.dragActor, ax, ay);
                    }
                });
            }
            this.dragActor = null;
            this.worldCanvas.setCursor(this.defaultCursor);
        }
    }

    public Actor getObject(int x, int y) {
        return WorldHandler.getObject(this.world, x, y);
    }

    private static Actor getObject(World world, int x, int y) {
        if (world == null) {
            return null;
        }
        int timeout = 500;
        try {
            if (lock.readLock().tryLock(timeout, TimeUnit.MILLISECONDS)) {
                Collection<Actor> objectsThere = WorldVisitor.getObjectsAtPixel(world, x, y);
                if (objectsThere.isEmpty()) {
                    lock.readLock().unlock();
                    return null;
                }
                Iterator<Actor> iter = objectsThere.iterator();
                Actor topmostActor = iter.next();
                int seq = ActorVisitor.getLastPaintSeqNum(topmostActor);
                while (iter.hasNext()) {
                    Actor actor = iter.next();
                    int actorSeq = ActorVisitor.getLastPaintSeqNum(actor);
                    if (actorSeq <= seq) continue;
                    topmostActor = actor;
                    seq = actorSeq;
                }
                lock.readLock().unlock();
                return topmostActor;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.worldCanvas.requestFocusInWindow();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.dragActor != null) {
            this.dragActorMoved = false;
            Simulation.getInstance().runLater(new Runnable(){
                private Actor dragActor;
                private int dragBeginX;
                private int dragBeginY;
                {
                    this.dragActor = WorldHandler.this.dragActor;
                    this.dragBeginX = WorldHandler.this.dragBeginX;
                    this.dragBeginY = WorldHandler.this.dragBeginY;
                }

                @Override
                public void run() {
                    ActorVisitor.setLocationInPixels(this.dragActor, this.dragBeginX, this.dragBeginY);
                    WorldHandler.this.repaint();
                }
            });
        }
    }

    public void repaint() {
        this.worldCanvas.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaintAndWait() {
        this.worldCanvas.repaint();
        boolean isWorldLocked = lock.isWriteLockedByCurrentThread();
        Object object = this.repaintLock;
        synchronized (object) {
            if (isWorldLocked) {
                lock.writeLock().unlock();
            }
            this.isRepaintPending = true;
            try {
                do {
                    this.repaintLock.wait(100L);
                } while (this.isRepaintPending);
            }
            catch (InterruptedException ie) {
                throw new ActInterruptedException();
            }
            finally {
                this.isRepaintPending = false;
                if (isWorldLocked) {
                    lock.writeLock().lock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repainted() {
        Object object = this.repaintLock;
        synchronized (object) {
            if (this.isRepaintPending) {
                this.isRepaintPending = false;
                this.repaintLock.notify();
            }
        }
        Simulation.getInstance().worldRepainted();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27 && this.dragActor != null) {
            this.dragActorMoved = false;
            Simulation.getInstance().runLater(new Runnable(){
                private Actor dragActor;
                private int dragBeginX;
                private int dragBeginY;
                {
                    this.dragActor = WorldHandler.this.dragActor;
                    this.dragBeginX = WorldHandler.this.dragBeginX;
                    this.dragBeginY = WorldHandler.this.dragBeginY;
                }

                @Override
                public void run() {
                    ActorVisitor.setLocationInPixels(this.dragActor, this.dragBeginX, this.dragBeginY);
                    WorldHandler.this.repaint();
                }
            });
            this.dragActor = null;
            this.worldCanvas.setCursor(this.defaultCursor);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.worldCanvas.requestFocus();
    }

    public ReentrantReadWriteLock getWorldLock() {
        return lock;
    }

    public void instantiateNewWorld() {
        this.handlerDelegate.instantiateNewWorld();
    }

    public void setInitialisingWorld(World world) {
        this.initialisingWorld = world;
    }

    public synchronized void discardWorld() {
        if (this.world == null) {
            return;
        }
        this.handlerDelegate.discardWorld(this.world);
        World discardedWorld = this.world;
        this.world = null;
        EventQueue.invokeLater(() -> {
            this.worldCanvas.setWorld(null);
            this.fireWorldRemovedEvent(discardedWorld);
        });
    }

    public synchronized boolean checkWorldSet() {
        return this.worldIsSet;
    }

    public synchronized void clearWorldSet() {
        this.worldIsSet = false;
    }

    public synchronized void setWorld(final World world) {
        this.worldIsSet = true;
        this.handlerDelegate.setWorld(this.world, world);
        this.mousePollingManager.setWorldLocator(new WorldLocator(){

            @Override
            public Actor getTopMostActorAt(MouseEvent e) {
                Point p = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), WorldHandler.this.worldCanvas);
                return WorldHandler.getObject(world, p.x, p.y);
            }

            @Override
            public int getTranslatedX(MouseEvent e) {
                Point p = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), WorldHandler.this.worldCanvas);
                return WorldVisitor.toCellFloor(world, p.x);
            }

            @Override
            public int getTranslatedY(MouseEvent e) {
                Point p = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), WorldHandler.this.worldCanvas);
                return WorldVisitor.toCellFloor(world, p.y);
            }
        });
        this.world = world;
        EventQueue.invokeLater(() -> {
            if (this.worldCanvas != null) {
                this.worldCanvas.setWorld(world);
            }
            this.fireWorldCreatedEvent(world);
        });
    }

    public synchronized World getWorld() {
        if (this.world == null) {
            return this.initialisingWorld;
        }
        return this.world;
    }

    public synchronized boolean hasWorld() {
        return this.world != null;
    }

    @Override
    public boolean drop(Object o, Point p) {
        World world = this.world;
        int maxHeight = WorldVisitor.getHeightInPixels(world);
        int maxWidth = WorldVisitor.getWidthInPixels(world);
        int x = (int)p.getX();
        int y = (int)p.getY();
        if (x >= maxWidth || y >= maxHeight || x < 0 || y < 0) {
            return false;
        }
        if (o instanceof ObjectDragProxy) {
            ObjectDragProxy to = (ObjectDragProxy)o;
            to.createRealObject();
            Simulation.getInstance().runLater(() -> world.removeObject(to));
            this.objectDropped = true;
            return true;
        }
        if (o instanceof Actor && ActorVisitor.getWorld((Actor)o) == null) {
            Actor actor = (Actor)o;
            this.addActorAtPixel(actor, x, y);
            this.objectDropped = true;
            return true;
        }
        if (o instanceof Actor) {
            Actor actor = (Actor)o;
            if (ActorVisitor.getWorld(actor) == null) {
                return false;
            }
            Simulation.getInstance().runLater(() -> ActorVisitor.setLocationInPixels(actor, x, y));
            this.dragActorMoved = true;
            this.objectDropped = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean drag(Object o, Point p) {
        World world = this.world;
        if (o instanceof Actor && world != null) {
            block7: {
                int x = WorldVisitor.toCellFloor(world, (int)p.getX() + this.dragOffsetX);
                int y = WorldVisitor.toCellFloor(world, (int)p.getY() + this.dragOffsetY);
                Actor actor = (Actor)o;
                try {
                    int oldX = ActorVisitor.getX(actor);
                    int oldY = ActorVisitor.getY(actor);
                    if (oldX == x && oldY == y) break block7;
                    if (x < WorldVisitor.getWidthInCells(world) && y < WorldVisitor.getHeightInCells(world) && x >= 0 && y >= 0) {
                        ReentrantReadWriteLock.WriteLock writeLock = lock.writeLock();
                        if (writeLock.tryLock()) {
                            ActorVisitor.setLocationInPixels(actor, (int)p.getX() + this.dragOffsetX, (int)p.getY() + this.dragOffsetY);
                            writeLock.unlock();
                            this.dragActorMoved = true;
                            this.repaint();
                        }
                        break block7;
                    }
                    ReentrantReadWriteLock.WriteLock writeLock = lock.writeLock();
                    if (writeLock.tryLock()) {
                        ActorVisitor.setLocationInPixels(actor, this.dragBeginX, this.dragBeginY);
                        x = WorldVisitor.toCellFloor(this.getWorld(), this.dragBeginX);
                        y = WorldVisitor.toCellFloor(this.getWorld(), this.dragBeginY);
                        this.handlerDelegate.actorDragged(actor, x, y);
                        writeLock.unlock();
                        this.dragActorMoved = false;
                        this.repaint();
                    }
                    return false;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    public synchronized boolean addObjectAtEvent(Actor actor, MouseEvent e) {
        Component source = (Component)e.getSource();
        if (source != this.worldCanvas) {
            e = SwingUtilities.convertMouseEvent(source, e, this.worldCanvas);
        }
        int xPixel = e.getX();
        int yPixel = e.getY();
        return this.addActorAtPixel(actor, xPixel, yPixel);
    }

    private boolean addActorAtPixel(Actor actor, int xPixel, int yPixel) {
        World world = this.world;
        int x = WorldVisitor.toCellFloor(world, xPixel);
        int y = WorldVisitor.toCellFloor(world, yPixel);
        if (x < WorldVisitor.getWidthInCells(world) && y < WorldVisitor.getHeightInCells(world) && x >= 0 && y >= 0) {
            Simulation.getInstance().runLater(() -> world.addObject(actor, x, y));
            this.handlerDelegate.addActor(actor, x, y);
            return true;
        }
        return false;
    }

    @Override
    public void dragEnded(Object o) {
        if (o instanceof Actor && this.world != null) {
            Actor actor = (Actor)o;
            Simulation.getInstance().runLater(() -> this.world.removeObject(actor));
        }
    }

    @Override
    public void dragFinished(Object o) {
        this.finishDrag(o);
    }

    protected void fireWorldCreatedEvent(World newWorld) {
        Object[] listeners = this.listenerList.getListenerList();
        WorldEvent worldEvent = new WorldEvent(newWorld);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != WorldListener.class) continue;
            ((WorldListener)listeners[i + 1]).worldCreated(worldEvent);
        }
    }

    public void fireWorldRemovedEvent(World discardedWorld) {
        Object[] listeners = this.listenerList.getListenerList();
        WorldEvent worldEvent = new WorldEvent(discardedWorld);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != WorldListener.class) continue;
            ((WorldListener)listeners[i + 1]).worldRemoved(worldEvent);
        }
    }

    public void addWorldListener(WorldListener l) {
        this.listenerList.add(WorldListener.class, l);
    }

    public void removeWorldListener(WorldListener l) {
        this.listenerList.remove(WorldListener.class, l);
    }

    private void startSequence() {
        World world = this.world;
        if (world != null) {
            WorldVisitor.startSequence(world);
            this.mousePollingManager.newActStarted();
        }
    }

    public WorldCanvas getWorldCanvas() {
        return this.worldCanvas;
    }

    public EventListenerList getListenerList() {
        return this.listenerList;
    }

    public void finishDrag(Object o) {
        if (!this.objectDropped && o instanceof Actor) {
            Actor actor = (Actor)o;
            this.objectDropped = true;
            this.dragActorMoved = false;
            Simulation.getInstance().runLater(() -> ActorVisitor.setLocationInPixels(actor, this.dragBeginX, this.dragBeginY));
        }
    }

    @Override
    public void simulationChanged(SimulationEvent e) {
        if (e.getType() == 7) {
            this.startSequence();
        } else {
            this.inputManager.simulationChanged(e);
        }
    }

    public ObjectBenchInterface getObjectBench() {
        if (this.handlerDelegate instanceof ObjectBenchInterface) {
            return (ObjectBenchInterface)this.handlerDelegate;
        }
        return null;
    }

    public InputManager getInputManager() {
        return this.inputManager;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.objectDropped = false;
            this.drag(this.dragActor, e.getPoint());
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.objectDropped = false;
        if (this.dragActor != null) {
            this.drag(this.dragActor, e.getPoint());
        }
        this.handlerDelegate.mouseMoved(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getSnapShot() {
        BufferedImage img;
        block6: {
            if (this.world == null) {
                return null;
            }
            WorldCanvas canvas = this.getWorldCanvas();
            img = GraphicsUtilities.createCompatibleImage(WorldVisitor.getWidthInPixels(this.world), WorldVisitor.getHeightInPixels(this.world));
            Graphics2D g = img.createGraphics();
            g.setColor(canvas.getBackground());
            g.fillRect(0, 0, img.getWidth(), img.getHeight());
            canvas.paintBackground(g);
            int timeout = 500;
            try {
                if (!lock.readLock().tryLock(timeout, TimeUnit.MILLISECONDS)) break block6;
                try {
                    canvas.paintObjects(g);
                }
                finally {
                    lock.readLock().unlock();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return img;
    }

    @Override
    public void listeningEnded() {
    }

    @Override
    public void listeningStarted(Object obj) {
        World world = this.world;
        if (world != null && obj != null && obj != this.dragActor && obj instanceof Actor) {
            Actor actor = (Actor)obj;
            int ax = ActorVisitor.getX(actor);
            int ay = ActorVisitor.getY(actor);
            int x = (int)Math.floor(WorldVisitor.getCellCenter(world, ax));
            int y = (int)Math.floor(WorldVisitor.getCellCenter(world, ay));
            Point p = new Point(x, y);
            this.startDrag(actor, p, world);
        }
    }

    public void objectAddedToWorld(Actor object) {
        this.handlerDelegate.objectAddedToWorld(object);
    }

    public String ask(String prompt) {
        boolean held = lock.isWriteLockedByCurrentThread();
        if (held) {
            lock.writeLock().unlock();
        }
        String answer = this.handlerDelegate.ask(prompt);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                WorldHandler.this.worldCanvas.requestFocusInWindow();
            }
        });
        if (held) {
            lock.writeLock().lock();
        }
        return answer;
    }

    static {
        lock = new ReentrantReadWriteLock();
    }
}

