/*
 * Decompiled with CFR 0.152.
 */
import greenfoot.Greenfoot;
import greenfoot.World;
import java.awt.Color;
import java.awt.Font;
import java.util.List;
import java.util.Random;

public class TVPWorld
extends World {
    private Random generator = new Random();
    private boolean[][] cellIsUsed = new boolean[30][22];
    public InfoBoard theInfoBoard;
    private boolean difficultyIsChosen = false;
    private boolean worldIsPopulated = false;
    private int gameDifficulty = 2;
    private static final int cellCountX = 30;
    private static final int cellCountY = 22;
    private static final int cellSize = 25;
    public static final int limitX = 23;
    public static final int limitY = 22;

    public TVPWorld() {
        super(30, 22, 25);
        this.setBackground("forside.jpg");
    }

    @Override
    public void act() {
        if (!this.difficultyIsChosen) {
            if (Greenfoot.isKeyDown("2")) {
                this.gameDifficulty = 2;
                this.difficultyIsChosen = true;
            }
        } else if (!this.worldIsPopulated) {
            this.setBackground("empty_25.jpg");
            this.populateTVPWorld();
            this.worldIsPopulated = true;
        }
    }

    public void populateTVPWorld() {
        this.initialiseCellIsUsed();
        this.createInfoBoard();
        this.setPaintOrder(ScoreBoard.class, Wall.class, Minion.class, Lilla.class, Gun.class);
        this.populateWall();
        Greenfoot.start();
        this.getBackground().setFont(new Font("", 5, 5));
        this.getBackground().setColor(Color.black);
        this.addObject(new Clock(true, true, 60, "Time left:"), 26, 2);
    }

    private void initialiseCellIsUsed() {
        for (int x = 0; x < 30; ++x) {
            for (int y = 0; y < 22; ++y) {
                this.cellIsUsed[x][y] = false;
            }
        }
    }

    public void populateWall() {
        int[] Map2 = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 1, 0, 0, 0, 0, 0, 1, 1, 2, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 2, 1, 0, 0, 0, 0, 0, 1, 1, 2, 1, 2, 2, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 2, 2, 2, 1, 0, 0, 0, 0, 0, 1, 1, 2, 1, 2, 2, 5, 2, 1, 2, 2, 1, 3, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 1, 0, 0, 0, 0, 0, 1, 1, 2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 2, 2, 1, 2, 1, 1, 1, 1, 1, 2, 5, 2, 1, 0, 0, 0, 0, 0, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 5, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0, 0, 0, 1, 1, 2, 2, 2, 1, 1, 1, 1, 2, 2, 1, 1, 1, 2, 1, 2, 2, 2, 2, 2, 1, 2, 2, 1, 0, 0, 0, 0, 0, 1, 1, 2, 2, 2, 1, 2, 2, 2, 2, 2, 1, 2, 2, 2, 1, 1, 1, 1, 1, 2, 1, 2, 2, 1, 0, 0, 0, 0, 0, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 2, 2, 1, 1, 1, 1, 2, 1, 0, 0, 0, 0, 0, 1, 1, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 2, 2, 2, 2, 2, 1, 2, 1, 0, 0, 0, 0, 0, 1, 1, 2, 2, 2, 1, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 1, 2, 1, 0, 0, 0, 0, 0, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 2, 1, 2, 4, 2, 2, 1, 1, 1, 1, 1, 2, 1, 2, 1, 0, 0, 0, 0, 0, 1, 1, 2, 2, 2, 2, 3, 1, 2, 5, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 5, 1, 0, 0, 0, 0, 0, 1, 1, 2, 2, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 1, 1, 1, 2, 2, 1, 2, 2, 1, 2, 1, 0, 0, 0, 0, 0, 1, 1, 2, 2, 1, 1, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 1, 0, 0, 0, 0, 0, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 2, 1, 0, 0, 0, 0, 0, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 1, 1, 2, 2, 1, 2, 2, 1, 2, 2, 1, 0, 0, 0, 0, 0, 1, 1, 2, 1, 1, 2, 2, 1, 2, 2, 2, 1, 2, 2, 1, 2, 2, 2, 1, 3, 2, 1, 2, 2, 1, 0, 0, 0, 0, 0, 1, 1, 2, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 2, 2, 1, 0, 0, 0, 0, 0, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        this.Level(Map2);
    }

    public void Level(int[] array) {
        int i = 0;
        for (int cellCountY = 0; cellCountY < 22; ++cellCountY) {
            for (int cellCountX = 0; cellCountX < 30; ++cellCountX) {
                int type = array[i];
                if (type != 0) {
                    if (type == 1) {
                        this.addObject(new Wall(), cellCountX, cellCountY);
                    } else if (type == 2) {
                        this.addObject(new Food(), cellCountX, cellCountY);
                    } else if (type == 3) {
                        this.addObject(new Gun(), cellCountX, cellCountY);
                    } else if (type == 4) {
                        this.addObject(new Minion(), cellCountX, cellCountY);
                    } else if (type == 5) {
                        this.addObject(new Lilla(), cellCountX, cellCountY);
                    }
                }
                if (i >= array.length - 1) continue;
                ++i;
            }
        }
    }

    private void createInfoBoard() {
        this.theInfoBoard = new InfoBoard();
        this.addObject(this.theInfoBoard, 26, 5);
    }

    public Minion getMinion() {
        List<Minion> theList = this.getObjects(Minion.class);
        if (theList.size() > 0) {
            return theList.get(0);
        }
        return null;
    }

    public int getGameDifficulty() {
        return this.gameDifficulty;
    }

    private void ScoreBoard() {
        ScoreBoard board = new ScoreBoard(600, 500);
        this.addObject(new ScoreBoard(600, 500), this.getWidth() / 2, this.getHeight() / 2);
    }

    public void EndGame() {
        this.ScoreBoard();
        Greenfoot.stop();
    }

    private static enum ActorType {
        Minion,
        food,
        Lilla,
        Gun;

    }
}

