/*
 * Decompiled with CFR 0.152.
 */
import greenfoot.Actor;
import greenfoot.GreenfootImage;
import greenfoot.UserInfo;
import java.awt.Color;
import java.util.List;

public class ScoreBoard
extends Actor {
    private static final int GAP = 10;
    private static final int HEADER_TEXT_HEIGHT = 25;
    private static final Color MAIN_COLOR = new Color(96, 96, 96);
    private static final Color SCORE_COLOR = new Color(176, 64, 64);
    private static final Color BACKGROUND_COLOR = new Color(255, 255, 255, 176);
    private static final Color BACKGROUND_HIGHLIGHT_COLOR = new Color(180, 230, 255, 176);

    public ScoreBoard(int width, int height) {
        this.setImage(new GreenfootImage(Math.max(600, width), height));
        this.drawScores();
    }

    private void drawString(String text, int x, int y, Color color, int height) {
        this.getImage().drawImage(new GreenfootImage(text, height, color, new Color(0, true)), x, y);
    }

    private void drawScores() {
        int pixelsPerUser = 70;
        int numUsers = (this.getImage().getHeight() - 35) / 70;
        int topSpace = this.getImage().getHeight() - numUsers * 70 - 10;
        this.getImage().setColor(BACKGROUND_COLOR);
        this.getImage().fill();
        this.drawString("All Players", 100, topSpace - 25 - 5, MAIN_COLOR, 25);
        this.drawString("Near You", 100 + this.getImage().getWidth() / 2, topSpace - 25 - 5, MAIN_COLOR, 25);
        this.drawUserPanel(10, topSpace, this.getImage().getWidth() / 2 - 10, topSpace + numUsers * 70, UserInfo.getTop(numUsers));
        this.drawUserPanel(10 + this.getImage().getWidth() / 2, topSpace, this.getImage().getWidth() - 10, topSpace + numUsers * 70, UserInfo.getNearby(numUsers));
    }

    private void drawUserPanel(int left, int top, int right, int bottom, List users) {
        this.getImage().setColor(MAIN_COLOR);
        this.getImage().drawRect(left, top, right - left, bottom - top);
        if (users == null) {
            return;
        }
        UserInfo me = UserInfo.getMyInfo();
        int y = top + 10;
        for (Object obj : users) {
            UserInfo playerData = (UserInfo)obj;
            Color c = me != null && playerData.getUserName().equals(me.getUserName()) ? BACKGROUND_HIGHLIGHT_COLOR : BACKGROUND_COLOR;
            this.getImage().setColor(c);
            this.getImage().fillRect(left + 5, y - 10 + 1, right - left - 10, 69);
            int x = left + 10;
            this.drawString("#" + Integer.toString(playerData.getRank()), x, y + 18, MAIN_COLOR, 14);
            this.drawString(Integer.toString(playerData.getScore()), x += 50, y + 18, SCORE_COLOR, 14);
            this.getImage().drawImage(playerData.getUserImage(), x += 80, y);
            this.drawString(playerData.getUserName(), x += 55, y + 18, MAIN_COLOR, 14);
            y += 70;
        }
    }
}

