/*
 * Decompiled with CFR 0.152.
 */
import greenfoot.Actor;
import greenfoot.GreenfootImage;
import java.awt.Color;
import java.awt.Font;

public class InfoBoard
extends Actor {
    private static final int boardLength = 80;
    private static final int boardWidth = 80;
    private static final int textStartX = 15;
    private static final int textScoreStartY = 35;
    private InfoItem scoreInfo = new InfoItem("Score");

    @Override
    public void act() {
    }

    public InfoBoard() {
        this.updateInfoItem(InfoItemType.score, 0);
        this.updateInfoBoard();
    }

    public void updateInfoItem(InfoItemType itemType, int value) {
        switch (itemType) {
            case score: {
                this.scoreInfo.setItemData(value);
            }
        }
        this.updateInfoBoard();
    }

    private void updateInfoBoard() {
        GreenfootImage image = this.createBoard(80, 80);
        this.drawScore(image);
        this.setImage(image);
    }

    private GreenfootImage createBoard(int x, int y) {
        GreenfootImage image = new GreenfootImage(x, y);
        image.setColor(Color.WHITE);
        image.fillRect(0, 0, x, y);
        return image;
    }

    private void drawScore(GreenfootImage image) {
        this.drawText(image, this.scoreInfo.toString(), 15, 35);
    }

    private void drawText(GreenfootImage image, String text, int x, int y) {
        Font font = image.getFont();
        font = font.deriveFont(18);
        image.setFont(font);
        image.setColor(Color.BLACK);
        image.drawString(text, x, y);
    }

    public static enum InfoItemType {
        hp,
        score;

    }

    private class InfoItem {
        private int itemData;
        private String itemText;

        public InfoItem(String text) {
            this.itemText = text;
        }

        public void setItemData(int data) {
            this.itemData = data;
        }

        public int getItemData() {
            return this.itemData;
        }

        public String toString() {
            return this.itemText + ": " + this.itemData;
        }
    }
}

